%Script eliminazioni punti esterni al dominio di calcolo
%Profilo NACA-2412 su dominio circolare
%Scritto da Pavan Andrea - 18/02/2022
clear;
clc;

%nodi profilo
airfoilNpoints = 100;
airfoil = naca4_generator('2412',airfoilNpoints);

%nodi contorno
% 'O' mesh
boundaryRadius = 3;     %raggio bordo esterno
boundaryNpoints = 50;      %numero punti bordo esterno
boundary(:,1) = 0.25 + boundaryRadius*cos(0:(2*pi/boundaryNpoints):2*pi);       %coordinate punti bordo esterno
boundary(:,2) = boundaryRadius*sin(0:(2*pi/boundaryNpoints):2*pi);
boundary(end,:) = [];

%punti random
NP = 2000;     %numero punti generati
P = rand(NP,2)-0.5;
P(:,1) = 0.25 + P(:,1)*2*boundaryRadius;
P(:,2) = P(:,2)*2*boundaryRadius;

%rimozione punti esterni dominio
for i=1:NP
    if check_internal_points(P(i,:),airfoil)==true || check_internal_points(P(i,:),boundary)==false
    %if check_internal_points(P(i,:),airfoil)==true
        P(i,:) = [NaN NaN];
    end
end


%grafico pointcloud
figure(1);
plot(airfoil(:,1),airfoil(:,2),'r.');
hold on;
plot(boundary(:,1),boundary(:,2),'b.');
% for j=1:length(P(:,1))
%     plot(P(j,1),P(j,2),'k.');
% end
plot(P(:,1),P(:,2),'k.');
title('Grafico pointcloud');
xlabel('x/c');
ylabel('y/c');
axis equal;
axis square;
hold off;
